<?php
namespace App\Http\Requests;

use App\Models\User;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class CreateRegisterRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $rules = User::$rules;

        // Password validation
        $rules['password'] = [
            'required',
            'string',
            'min:8',              // At least 8 characters
            'confirmed',          // Matches password_confirmation field
            'regex:/[a-z]/',      // At least one lowercase letter
            'regex:/[A-Z]/',      // At least one uppercase letter
            'regex:/[0-9]/',      // At least one number
            'regex:/[@$!%*#?&]/'  // At least one special character
        ];

        $rules['term_policy_check'] = 'required';

        if (getSuperAdminSettingValue('captcha_enable')) {
            $rules['g-recaptcha-response'] = 'required|recaptcha';
        }

        return $rules;
    }

    public function messages(): array
    {
        return [
            'password.required' => __('messages.placeholder.password_required'),
            'password.min' => __('messages.placeholder.password_min'),
            'password.confirmed' => __('messages.placeholder.password_confirmed'),
            'password.regex' => __('messages.placeholder.password_complexity'),
            'term_policy_check.required' => __('messages.placeholder.agree_term'),
            'g-recaptcha-response.required' => __('messages.placeholder.required_captcha'),
        ];
    }
}
