<?php

namespace App\Http\Requests;

use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;

class CreateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = User::$rules;
        $rules['profile'] = 'mimes:jpg,bmp,png,apng,avif,jpeg,';



        // Password validation - same as register form
        $rules['password'] = [
            'required',
            'string',
            'min:8',              // At least 8 characters
            'confirmed',          // Matches password_confirmation field
            'regex:/[a-z]/',      // At least one lowercase letter
            'regex:/[A-Z]/',      // At least one uppercase letter
            'regex:/[0-9]/',      // At least one number
            'regex:/[@$!%*#?&]/'  // At least one special character
        ];

        return $rules;
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'password.required' => __('messages.placeholder.password_required'),
            'password.min' => __('messages.placeholder.password_min'),
            'password.confirmed' => __('messages.placeholder.password_confirmed'),
            'password.regex' => __('messages.placeholder.password_complexity'),
        ];
    }
}
