<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class GetStartedContactMail extends Mailable
{
    use Queueable, SerializesModels;

    public $input;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($input)
    {
        $this->input = $input;
    }

    /**
     * Build the message.
     */
    public function build(): static
    {
        $subject = __('messages.mail.contact_form_submission') ?? 'New Contact Form Submission - Get Started';

        return $this->subject($subject)
            ->markdown('emails.get_started_contact')
            ->with($this->input);
    }
}

