<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PaymentSuccessMail extends Mailable
{
    use Queueable, SerializesModels;

    public $subscription;
    public $amount;

    public $user;

    public function __construct($subscription, $amount, $user)
    {
        $this->subscription = $subscription;
        $this->amount = $amount;
        $this->user = $user;
    }


    public function build()
    {
        return $this->subject('Payment Successful')
            ->markdown('emails.payment_success');

    }
}
