<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SubscriptionExpirationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $subscription;
    public $user;
    public $daysRemaining;
    public $expirationDate;
    public $isExpired;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($subscription, $user, $daysRemaining, $isExpired = false)
    {
        $this->subscription = $subscription;
        $this->user = $user;
        $this->daysRemaining = $daysRemaining;
        $this->isExpired = $isExpired;

        // Determine expiration date
        $this->expirationDate = $subscription->trial_ends_at
            ? $subscription->trial_ends_at
            : $subscription->ends_at;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $subject = $this->isExpired
            ? __('messages.subscription.expired_notification_subject', ['plan' => $this->subscription->plan->name])
            : __('messages.subscription.expiring_notification_subject', ['days' => $this->daysRemaining, 'plan' => $this->subscription->plan->name]);

        return $this->subject($subject)
            ->view('emails.subscription_expiration');
    }
}



