<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CardAccessToken extends Model
{
    use HasFactory;
    protected $table = 'card_access_tokens';

    protected $fillable = ['id', 'vcard_id', 'token_hash', 'revoked','revoked_at'];

    public $incrementing = false;
    protected $keyType = 'string';

    public function vcard()
    {
        return $this->belongsTo(Vcard::class);
    }
}
