<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserPrivacySetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'is_locked',
        'expiry_type',
        'custom_days',
        'expires_at',
        'share_link',
        'share_jwt',
    ];
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    protected $casts = [
        'is_locked'  => 'boolean',
        // 'share_link' => 'boolean',
        'expires_at' => 'datetime',
    ];

}
