$(document).ready(function() {
    let requestedCards;

    // Open the downgrade modal
    $(document).on('click', '#downgradeBtn', function() {
        console.log("Downgrade button clicked");
        $('#downgradeModal').modal('show');
    });

    // Handle input change
    $(document).on('input', '#cardCount', function() {
        requestedCards = $(this).val();
        console.log("Requested Cards (Input Field):", requestedCards);

        if (requestedCards > 0) {
            $("#downgradeCalculationResult").text(
                "You have selected " + requestedCards + " cards."
            );
        } else {
            $("#downgradeCalculationResult").text('');
        }
    });

    // Confirm downgrade
    $(document).on('click', '#confirmDowngrade', function() {
        console.log("Requested Cards (Raw):", requestedCards);

        requestedCards = requestedCards.trim();
        let parsedRequestedCards = parseInt(requestedCards, 10);
        console.log("Requested Cards (Parsed):", parsedRequestedCards);

        if (!isNaN(parsedRequestedCards) && parsedRequestedCards > 0) {
            $.post(downgradeRequestUrl, {
                requested_cards: parsedRequestedCards,
                _token: csrf
            }, function(res) {
                if (res.success) {
                    // ✅ success toast
                    // toastr.success(res.message);
                    window.location.href = res.payment_url;
                } else {
                    // ❌ error toast
                    // toastr.error(res.message);
                }
            }).fail(function(xhr) {
                // In case of validation 400/500 errors
                let errorMessage = xhr.responseJSON?.message || "Something went wrong!";
                toastr.error(errorMessage);
            });
        } else {
            toastr.warning("Please enter a valid number of cards greater than 0.");
        }
    });
});
