$( document ).ready(function() {
    
 	$(document).on('click', '#requestCardBtn', function() {
        $('#requestMoreCard').modal('show');
    });

	$(document).on('input', '#cardCount', function() {
	    let requestedCards = $(this).val();
	    if (requestedCards > 0) {
	        $.ajax({
	            url: calculateUrl,
	            type: "POST",
	            data: {
	                requested_cards: requestedCards,
	                _token: csrf
	            },
	            success: function(res) {
	                $("#calculationResult").text(
	                    "For " + res.requested_cards + " cards, you need to pay $" + res.amount +
	                    " (remaining " + res.remaining_days + " days)."
	                );
	            }
	        });
	    }
	});


	$(document).on('click', '#confirmRequest', function() {
	    let requestedCards = $("#cardCount").val();
	    if (requestedCards > 0) {	        
	        $.post(cardRequestStoreUrl, {
	            requested_cards: requestedCards,
	            _token: csrf
	        }, function(res) {	        	
	            window.location.href = res.payment_url;
	        });
	    }
	});


});