@extends('front.layouts.app')
@section('title')
    {{ getAppName() }}
@endsection
@section('content')
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#0B84FF',
                        secondary: '#1A2B48'
                    },
                    borderRadius: {
                        'none': '0px',
                        'sm': '4px',
                        DEFAULT: '8px',
                        'md': '12px',
                        'lg': '16px',
                        'xl': '20px',
                        '2xl': '24px',
                        '3xl': '32px',
                        'full': '9999px',
                        'button': '8px'
                    },
                    fontFamily: {
                        inter: ['Inter', 'sans-serif'],
                        pacifico: ['Pacifico', 'serif']
                    }
                }
            }
        }
    </script>
    <style>
        :where([class^="ri-"])::before {
            content: "\f3c2";
        }

        body {
            font-family: 'Inter', sans-serif;
        }

        .hero-bg {
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #334155 100%);
        }

        .hero-overlay {
            background: linear-gradient(135deg, rgba(15, 23, 42, 0.95) 0%, rgba(30, 41, 59, 0.97) 50%, rgba(51, 65, 85, 0.95) 100%);
        }

        .glass-card {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .feature-card {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .feature-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
        }

        .btn-primary {
            background: linear-gradient(135deg, #0B84FF 0%, #667eea 100%);
            box-shadow: 0 10px 25px -5px rgba(11, 132, 255, 0.4);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 20px 40px -5px rgba(11, 132, 255, 0.5);
        }

        .btn-secondary {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .btn-secondary:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-2px);
        }

        .pricing-card {
            transition: all 0.3s ease;
        }

        .pricing-card:hover {
            transform: translateY(-5px);
        }

        .custom-switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 32px;
        }

        .custom-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .switch-slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, #e2e8f0 0%, #cbd5e1 100%);
            transition: .4s;
            border-radius: 32px;
        }

        .switch-slider:before {
            position: absolute;
            content: "";
            height: 24px;
            width: 24px;
            left: 4px;
            bottom: 4px;
            background: white;
            transition: .4s;
            border-radius: 50%;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
        }

        input:checked+.switch-slider {
            background: linear-gradient(135deg, #0B84FF 0%, #667eea 100%);
        }

        input:checked+.switch-slider:before {
            transform: translateX(28px);
        }

        .enterprise-bg {
            background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 50%, #1d4ed8 100%);
            position: relative;
            overflow: hidden;
        }

        .enterprise-bg::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 20% 50%, rgba(11, 132, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(102, 126, 234, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 40% 80%, rgba(118, 75, 162, 0.1) 0%, transparent 50%);
        }

        .floating-card {
            animation: float 6s ease-in-out infinite;
        }

        @keyframes float {

            0%,
            100% {
                transform: translateY(0px);
            }

            50% {
                transform: translateY(-20px);
            }
        }

        .gradient-text {
            background: linear-gradient(135deg, #0B84FF 0%, #667eea 50%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .testimonial-card {
            background: rgba(255, 255, 255, 0.02);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .video-container {
            position: relative;
            width: 100%;
            height: 0;
            padding-bottom: 56.25%;
            border-radius: 1.5rem;
            overflow: hidden;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.4);
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            aspect-ratio: 16/9;
        }

        .video-placeholder {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            items-center: center;
            justify-content: center;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 100%);
        }

        .play-button {
            width: 80px;
            height: 80px;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .play-button:hover {
            transform: scale(1.1);
            background: white;
        }
    </style>
    <!-- Hero Section -->
    <section class="relative min-h-screen flex items-center overflow-hidden hero-bg pt-24">
        <div class="absolute inset-0 hero-overlay"></div>
        <div class="container mx-auto px-6 relative z-10">
            <div class="text-center mb-12">
                <div
                    class="inline-flex items-center px-6 py-3 bg-white/10 backdrop-blur-md rounded-full text-white/90 text-sm font-medium border border-white/20">
                    <i class="ri-sparkle-line mr-2"></i>
                    The Future of Professional Networking
                </div>
            </div>
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-16 items-start mb-12 lg:mb-16">
                <div class="text-white text-center lg:order-1">
                    {{-- <h1 class="text-4xl lg:text-6xl font-bold mb-6 lg:mb-8 leading-tight">
                        Your <span class="gradient-text">Smartest</span><br />
                        Business Card Ever
                    </h1> --}}
                    <h1 class=" text-white text-4xl lg:text-6xl font-bold mb-6 lg:mb-8 leading-tight checking-live">
                        {{ $setting['home_page_title'] }}</h1>
                    {{-- <p class="text-lg lg:text-xl text-white/80 mb-8 lg:mb-12 leading-relaxed">
                        Transform your networking experience with intelligent digital business cards. Share your
                        professional identity instantly with a tap, scan, or click.
                    </p> --}}
                    <p class="text-lg lg:text-xl text-white/80 mb-8 lg:mb-12 leading-relaxed">
                        {{ $setting['sub_text'] ?? '' }}</p>
                    <div class="hidden lg:flex flex-col sm:flex-row gap-6 justify-center">

                        <a href="{{ route('register') }}"
                            class="btn-primary px-8 py-4 text-white rounded-button text-lg font-semibold transition-all duration-300 whitespace-nowrap !rounded-button border-0">
                            <i class="ri-rocket-line mr-2"></i>
                            Get Started Free
                        </a>
                        <a href="javascript:void(0)" onclick="openModal()"
                            class="btn-secondary px-8 py-4 text-white rounded-button text-lg font-semibold transition-all duration-300 whitespace-nowrap !rounded-button flex items-center">
                            <span
                                class="w-6 h-6 flex items-center justify-center mr-2 bg-primary/10 rounded-full group-hover:bg-primary/20">
                                <i class="ri-play-fill text-white"></i>
                            </span>
                            <span class="text-lg font-medium">Watch Demo</span>
                        </a>
                        <div id="videoModal"
                            class="fixed inset-0 bg-black bg-opacity-70 flex items-center justify-center z-50 hidden"
                            onclick="handleOutsideClick(event)">
                            <div class="relative bg-white rounded-xl overflow-hidden w-full max-w-3xl"
                                id="videoModalContent">
                                <!-- Close Button -->
                                <button onclick="closeModal()"
                                    class="absolute top-2 right-2 text-white text-2xl z-10">&times;</button>

                                <!-- Video -->
                                <video id="videoElement" width="100%" controls>
                                    <source src="{{ config('app.url') }}/uploads/profile/output.mp4" type="video/mp4">
                                    Your browser does not support the video tag.
                                </video>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative pt-4 lg:order-2 lg:-mt-4">
                    <div style="padding:56.25% 0 0 0;position:relative;border-radius: 30px; overflow: hidden;"><iframe src="https://player.vimeo.com/video/1135317631?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479&amp;autoplay=1&amp;loop=1&amp;controls=0" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media; web-share" referrerpolicy="strict-origin-when-cross-origin" style="position:absolute;top:0;left:0;width:105%;height:105%;left:-2.5%;top:-2.5%;" title="ebizcard intro"></iframe></div><script src="https://player.vimeo.com/api/player.js"></script>
                </div>
                <div class="lg:hidden lg:order-3 flex flex-col gap-4 justify-center items-center mt-6">
                    <a href="#get-started"
                        class="btn-primary px-8 py-4 text-white rounded-button text-lg font-semibold transition-all duration-300 whitespace-nowrap !rounded-button">
                        <i class="ri-rocket-line mr-2"></i>
                        Get Started Free
                    </a>
                    <a href="#watch-demo"
                        class="btn-secondary px-8 py-4 text-white rounded-button text-lg font-semibold transition-all duration-300 whitespace-nowrap !rounded-button flex items-center justify-center">
                        <div class="w-8 h-8 bg-white/20 rounded-full flex items-center justify-center mr-3">
                            <i class="ri-play-fill text-white"></i>
                        </div>
                        Watch Demo
                    </a>
                </div>
            </div>
            <div
                class="flex flex-col sm:flex-row items-center justify-center gap-6 lg:gap-8 text-white/70 max-w-4xl mx-auto mt-8 lg:mt-0 mb-7">
                <div class="flex items-center">
                    <div class="flex -space-x-0 mr-4">
                        <div
                            class="w-12 h-12 rounded-full bg-gradient-to-br from-blue-400 to-indigo-600 border-2 border-white/20 flex items-center justify-center text-white text-xs font-bold">
                            🌍99+
                        </div>
                        <div
                            class="w-12 h-12 rounded-full bg-gradient-to-br from-green-500 to-yellow-400 border-2 border-white/20 flex items-center justify-center text-white text-xs font-bold">
                            🇱🇰99+
                        </div>
                        <div
                            class="w-12 h-12 rounded-full bg-gradient-to-br from-red-500 to-blue-600 border-2 border-white/20 flex items-center justify-center text-white text-xs font-bold">
                            🇰🇭99+
                        </div>
                    </div>
                    <div>
                        <div class="text-white font-semibold">10,000+ Users</div>
                        <div class="text-sm">Join the revolution</div>
                    </div>
                </div>
                <div class="flex items-center">
                    <div class="flex text-yellow-400 mr-2">
                        <i class="ri-star-fill"></i>
                        <i class="ri-star-fill"></i>
                        <i class="ri-star-fill"></i>
                        <i class="ri-star-fill"></i>
                        <i class="ri-star-fill"></i>
                    </div>
                    <div>
                        <div class="text-white font-semibold">4.9/5 Rating</div>
                        <div class="text-sm">Loved by professionals</div>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </section>
    {{-- <section class="w-full relative pt-40 pb-32 overflow-hidden bg-gradient-to-br from-[#F8FBFF] via-white to-[#F0F7FF] min-h-[90vh]">
        <div class="absolute right-0 top-0 w-2/3 h-full">
            <div class="absolute inset-0 bg-[url('{{ isset($setting['home_page_banner']) ? $setting['home_page_banner'] : asset('assets/img/new_front/hero-img.png') }}')] bg-cover bg-center opacity-95"></div>
            <div class="absolute inset-0 bg-gradient-to-r from-[#F8FBFF] via-[#F8FBFF]/80 to-transparent"></div>
        </div>
        <div class="absolute -top-1/2 -left-1/2 w-full h-full bg-gradient-radial from-primary/5 to-transparent rounded-full blur-3xl"></div>
        <div class="container mx-auto px-4 relative">
            <div class="flex flex-col md:flex-row items-center">
                <div class="w-full md:w-1/2 mb-10 md:mb-0 z-10 relative">
                    <div class="absolute -top-20 -left-20 w-40 h-40 bg-primary/5 rounded-full blur-2xl"></div>
                    <div class="absolute -bottom-20 -right-20 w-40 h-40 bg-primary/5 rounded-full blur-2xl"></div>
                    <span class="inline-block px-4 py-2 bg-primary/10 text-primary rounded-full text-sm font-medium mb-6">The Future of Networking</span>
                    <h1 class="text-5xl md:text-7xl font-bold mb-8 leading-tight bg-clip-text text-transparent bg-gradient-to-r from-secondary via-secondary to-primary">{{ $setting['home_page_title'] }}</h1>
                    <p class="text-xl text-gray-600 mb-10 max-w-lg leading-relaxed"> {{ $setting['sub_text'] ?? '' }}</p>
                    <div class="flex flex-col sm:flex-row gap-6">
                        @if (empty(getLogInUser()))
                            <a href="{{ config('app.url') }}/admin/choose-payment-type/1"
                            onclick="pauseAndRedirect(event)"
                            class="px-8 py-4 bg-primary text-white rounded-button text-lg font-medium text-center hover:bg-primary/90 transition-colors whitespace-nowrap !rounded-button shadow-lg shadow-primary/20 hover:shadow-xl hover:shadow-primary/30 transform hover:-translate-y-0.5">
                                Get Started Free
                            </a>
                        @endif
                        <a href="javascript:void(0)" onclick="openModal()" class="px-8 py-4 bg-white border-2 border-gray-200 rounded-button text-gray-700 flex items-center justify-center hover:border-primary hover:text-primary transition-colors whitespace-nowrap group">
                            <span class="w-6 h-6 flex items-center justify-center mr-2 bg-primary/10 rounded-full group-hover:bg-primary/20">
                                <i class="ri-play-fill text-primary"></i>
                            </span>
                            <span class="text-lg font-medium">Watch Demo</span>
                        </a>
                <div id="videoModal" class="fixed inset-0 bg-black bg-opacity-70 flex items-center justify-center z-50 hidden"
                onclick="handleOutsideClick(event)">
                <div class="relative bg-white rounded-xl overflow-hidden w-full max-w-3xl" id="videoModalContent">
                    <!-- Close Button -->
                    <button onclick="closeModal()" class="absolute top-2 right-2 text-white text-2xl z-10">&times;</button>

                    <!-- Video -->
                    <video id="videoElement" width="100%" controls>
                        <source src="{{ config('app.url') }}/uploads/profile/output.mp4" type="video/mp4">
                        Your browser does not support the video tag.
                    </video>
                </div>
             </div>

                    </div>
                    <div class="flex items-center mt-12 space-x-8">
                        <div class="flex -space-x-3">
                            <div class="w-10 h-10 rounded-full border-2 border-white bg-gray-200"></div>
                            <div class="w-10 h-10 rounded-full border-2 border-white bg-gray-200"></div>
                            <div class="w-10 h-10 rounded-full border-2 border-white bg-gray-200"></div>
                            <div class="w-10 h-10 rounded-full border-2 border-white bg-primary flex items-center justify-center text-white text-sm">99+</div>
                        </div>
                        <div class="text-gray-600">
                            <span class="font-semibold text-gray-800">4.9/5</span> from over 10,000+ users
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section> --}}

    <!-- end hero section -->
    <section id="enterprise" class="py-12 md:py-16 lg:py-24 enterprise-bg relative">
        <div class="container mx-auto px-4 sm:px-6 relative z-10">
            <div class="text-center mb-12 md:mb-16 lg:mb-20">
                <div
                    class="inline-flex items-center px-4 py-2 md:px-6 md:py-3 lg:px-8 lg:py-4 glass-card rounded-full text-white mb-4 md:mb-6 lg:mb-8 text-sm md:text-base lg:text-lg">
                    <i class="ri-building-line mr-2 md:mr-3 text-base md:text-lg lg:text-xl"></i>
                    <span class="font-semibold">Enterprise Solution</span>
                </div>
                <h2
                    class="text-3xl sm:text-4xl md:text-5xl lg:text-7xl font-bold mb-4 md:mb-6 lg:mb-8 text-white leading-tight px-2">
                    Revolutionary<br />
                    <span class="gradient-text">Employee Cards</span>
                </h2>
                <p
                    class="text-base md:text-lg lg:text-xl xl:text-2xl text-blue-100 max-w-4xl mx-auto mb-8 md:mb-10 lg:mb-12 leading-relaxed px-4">
                    The ultimate all-in-one employee solution that replaces traditional ID cards, business cards, and access
                    control systems with one intelligent card.
                </p>
                <div class="flex flex-wrap justify-center gap-3 md:gap-4 text-blue-200 text-sm md:text-base">
                    <div class="glass-card px-4 py-2 md:px-6 md:py-3 rounded-full flex items-center">
                        <i class="ri-check-double-line text-green-400 mr-2"></i>
                        <span>Digital Business Card</span>
                    </div>
                    <div class="glass-card px-4 py-2 md:px-6 md:py-3 rounded-full flex items-center">
                        <i class="ri-check-double-line text-green-400 mr-2"></i>
                        <span>Access Control</span>
                    </div>
                    <div class="glass-card px-4 py-2 md:px-6 md:py-3 rounded-full flex items-center">
                        <i class="ri-check-double-line text-green-400 mr-2"></i>
                        <span>Employee ID System</span>
                    </div>
                </div>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 md:gap-10 lg:gap-12 items-stretch mb-12 md:mb-14 lg:mb-16">
                <div class="relative flex">
                    <div
                        class="absolute -top-2 -right-2 md:-top-4 md:-right-4 bg-gradient-to-r from-green-400 to-emerald-500 text-white px-4 py-2 md:px-6 md:py-3 rounded-full font-bold shadow-2xl z-20 text-xs md:text-sm">
                        <i class="ri-fire-line mr-1 md:mr-2"></i>
                        3-in-1 Tech
                    </div>
                    <div class="floating-card w-full">
                        <div
                            class="glass-card rounded-2xl md:rounded-3xl p-4 md:p-6 lg:p-8 relative overflow-hidden h-full flex items-center justify-center">
                            <div class="absolute inset-0 bg-gradient-to-br from-primary/20 to-purple-600/20"></div>
                            <img src="https://static.readdy.ai/image/ebe8a9b7c6bcd5c646860382bb233986/3bc5edca95857279e624cfdad4db6cbd.png"
                                alt="Revolutionary Employee Card"
                                class="w-2/3 md:w-3/5 h-auto max-w-[200px] md:max-w-xs rounded-xl md:rounded-2xl relative z-10 object-contain">
                        </div>
                    </div>
                </div>
                <div class="space-y-4 md:space-y-5 lg:space-y-6 flex flex-col">
                    <div
                        class="glass-card rounded-xl md:rounded-2xl p-5 md:p-6 lg:p-8 hover:bg-white/20 transition-all duration-300 group">
                        <div class="flex items-start">
                            <div
                                class="w-12 h-12 md:w-14 md:h-14 lg:w-16 lg:h-16 bg-gradient-to-br from-primary to-blue-600 rounded-xl md:rounded-2xl flex items-center justify-center mr-4 md:mr-5 lg:mr-6 group-hover:scale-110 transition-transform duration-300 flex-shrink-0">
                                <i class="ri-user-star-line text-white text-xl md:text-2xl"></i>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-lg md:text-xl lg:text-2xl font-bold text-white mb-2 md:mb-3 lg:mb-4">
                                    Employee ID System</h3>
                                <p class="text-blue-100 text-sm md:text-base lg:text-lg leading-relaxed">Professional
                                    printed cards with employee
                                    photos, contact details, and corporate branding that elevates your team's professional
                                    image.</p>
                            </div>
                        </div>
                    </div>
                    <div
                        class="glass-card rounded-xl md:rounded-2xl p-5 md:p-6 lg:p-8 hover:bg-white/20 transition-all duration-300 group">
                        <div class="flex items-start">
                            <div
                                class="w-12 h-12 md:w-14 md:h-14 lg:w-16 lg:h-16 bg-gradient-to-br from-emerald-500 to-green-600 rounded-xl md:rounded-2xl flex items-center justify-center mr-4 md:mr-5 lg:mr-6 group-hover:scale-110 transition-transform duration-300 flex-shrink-0">
                                <i class="ri-qr-code-line text-white text-xl md:text-2xl"></i>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-lg md:text-xl lg:text-2xl font-bold text-white mb-2 md:mb-3 lg:mb-4">
                                    Digital Business Card</h3>
                                <p class="text-blue-100 text-sm md:text-base lg:text-lg leading-relaxed">QR code and NFC
                                    technology for instant
                                    contact sharing. Transform every employee into a networking superstar.</p>
                            </div>
                        </div>
                    </div>
                    <div
                        class="glass-card rounded-xl md:rounded-2xl p-5 md:p-6 lg:p-8 hover:bg-white/20 transition-all duration-300 group">
                        <div class="flex items-start">
                            <div
                                class="w-12 h-12 md:w-14 md:h-14 lg:w-16 lg:h-16 bg-gradient-to-br from-orange-500 to-red-600 rounded-xl md:rounded-2xl flex items-center justify-center mr-4 md:mr-5 lg:mr-6 group-hover:scale-110 transition-transform duration-300 flex-shrink-0">
                                <i class="ri-door-lock-line text-white text-xl md:text-2xl"></i>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-lg md:text-xl lg:text-2xl font-bold text-white mb-2 md:mb-3 lg:mb-4">Smart
                                    Access Control</h3>
                                <p class="text-blue-100 text-sm md:text-base lg:text-lg leading-relaxed">RFID-enabled for
                                    seamless access to doors,
                                    elevators, and facilities. One card replaces your entire access system.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center">
                <div class="glass-card rounded-2xl md:rounded-3xl p-6 md:p-8 lg:p-12 max-w-4xl mx-auto">
                    <h3 class="text-2xl md:text-3xl lg:text-4xl font-bold text-white mb-4 md:mb-6 lg:mb-8">Ready to
                        Transform Your Workplace?</h3>
                    <p class="text-base md:text-lg lg:text-xl text-blue-100 mb-6 md:mb-8 lg:mb-10 leading-relaxed px-2">Get
                        a custom enterprise solution that will
                        revolutionize how your team connects and operates.</p>
                    <div class="flex flex-col sm:flex-row gap-4 md:gap-5 lg:gap-6 justify-center">
                        <a href="#enterprise-demo"
                            class="btn-primary px-6 py-3 md:px-8 md:py-4 lg:px-10 lg:py-5 text-white rounded-xl md:rounded-2xl text-base md:text-lg lg:text-xl font-bold transition-all duration-300 whitespace-nowrap !rounded-button flex items-center justify-center">
                            <i class="ri-customer-service-2-line mr-2 md:mr-3"></i>
                            Get Enterprise Demo
                        </a>
                        <a href="javascript:void(0)" onclick="openContactModal()"
                            class="btn-secondary px-6 py-3 md:px-8 md:py-4 lg:px-10 lg:py-5 text-white rounded-xl md:rounded-2xl text-base md:text-lg lg:text-xl font-bold transition-all duration-300 whitespace-nowrap !rounded-button flex items-center justify-center">
                            <i class="ri-phone-line mr-2 md:mr-3"></i>
                            Contact Sales
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- start features section -->
    <section id="features" class="py-20 bg-[#F8FBFF]">
        <div class="container mx-auto px-4">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold text-secondary mb-4">Powerful Features</h2>
                <p class="text-lg text-gray-600 max-w-2xl mx-auto">Everything you need to create, share, and manage your
                    digital business identity.</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Feature 1 -->
                <?php $i = 0; ?>
                @foreach ($features as $feature)
                    <?php
                    $class = '';
                    if ($i == 0) {
                        $class = 'ri-nfc-line';
                    } elseif ($i == 1) {
                        $class = 'ri-dashboard-line';
                    } elseif ($i == 2) {
                        $class = 'ri-layout-4-line';
                    } elseif ($i == 3) {
                        $class = 'ri-line-chart-line';
                    }
                    ?>
                    <div
                        class="feature-card bg-white p-8 rounded-lg shadow-sm hover:shadow-lg transition-all duration-300">
                        <div class="w-14 h-14 bg-primary/10 rounded-full flex items-center justify-center mb-6 mx-auto">
                            <i class="{{ $class ?? '' }} text-primary ri-xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-secondary mb-3 text-center">{{ $feature->name }}</h3>
                        <p class="text-gray-600 text-center">{{ $feature->description }}</p>
                    </div>
                    <?php $i++; ?>
                @endforeach

            </div>
        </div>
    </section>


    <!-- end features section -->

    <!-- How It Works Section -->

    <section id="enterprise-how-work" class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold text-secondary mb-4">
                    How It Works
                </h2>
                <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                    Get started with ebizcard in three simple steps.
                </p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-4xl mx-auto">
                <!-- Step 1 -->
                <div class="text-center">
                    <div
                        class="w-16 h-16 bg-primary text-white rounded-full flex items-center justify-center text-2xl font-bold mb-6 mx-auto">
                        1
                    </div>
                    <h3 class="text-xl font-semibold text-secondary mb-3">
                        Sign Up
                    </h3>
                    <p class="text-gray-600">
                        Create your account in seconds and access your dashboard.
                    </p>
                    <div class="mt-8 rounded-lg overflow-hidden shadow-sm">
                        <img src="https://readdy.ai/api/search-image?query=A%20professional%20person%20signing%20up%20on%20a%20laptop%20with%20a%20modern%20interface%20showing%20a%20business%20card%20creation%20platform.%20The%20scene%20features%20soft%20lighting%2C%20clean%20desk%20setup%20with%20minimal%20accessories%2C%20and%20a%20focused%20expression.%20The%20interface%20is%20modern%20and%20user-friendly%20with%20a%20signup%20form%20visible.%20High-quality%20professional%20photography%20with%20attention%20to%20detail&width=400&height=300&seq=signup1&orientation=landscape"
                            alt="Sign Up Process" class="w-full h-48 object-cover object-top">
                    </div>
                </div>
                <!-- Step 2 -->
                <div class="text-center relative">
                    <div class="hidden md:block absolute top-8 left-0 right-0 h-0.5 bg-gray-200">
                        <div class="absolute left-0 top-0 bottom-0 bg-primary" style="width: 50%;">
                        </div>
                    </div>
                    <div
                        class="w-16 h-16 bg-primary text-white rounded-full flex items-center justify-center text-2xl font-bold mb-6 mx-auto relative z-10">
                        2
                    </div>
                    <h3 class="text-xl font-semibold text-secondary mb-3">
                        Customize Card
                    </h3>
                    <p class="text-gray-600">
                        Add your info, links, and branding to make it uniquely yours.
                    </p>
                    <div class="mt-8 rounded-lg overflow-hidden shadow-sm">
                        <img src="https://readdy.ai/api/search-image?query=A%20person%20customizing%20a%20digital%20business%20card%20on%20a%20modern%20computer%20screen.%20The%20interface%20shows%20a%20sleek%20business%20card%20template%20being%20edited%20with%20drag%20and%20drop%20elements%2C%20color%20customization%2C%20and%20profile%20information.%20The%20scene%20has%20warm%20lighting%20and%20shows%20hands%20typing%20on%20a%20keyboard.%20Professional%20photography%20with%20clean%20composition&width=400&height=300&seq=customize1&orientation=landscape"
                            alt="Customize Card" class="w-full h-48 object-cover object-top">
                    </div>
                </div>
                <!-- Step 3 -->
                <div class="text-center">
                    <div
                        class="w-16 h-16 bg-primary text-white rounded-full flex items-center justify-center text-2xl font-bold mb-6 mx-auto">
                        3
                    </div>
                    <h3 class="text-xl font-semibold text-secondary mb-3">
                        Share Instantly
                    </h3>
                    <p class="text-gray-600">
                        Share via NFC tap, QR code, or digital link. Connect anywhere.
                    </p>
                    <div class="mt-8 rounded-lg overflow-hidden shadow-sm">
                        <img src="https://readdy.ai/api/search-image?query=Two%20business%20professionals%20exchanging%20contact%20information%20using%20NFC-enabled%20phones%2C%20with%20one%20phone%20displaying%20a%20digital%20business%20card%20and%20the%20other%20showing%20a%20successful%20connection%20animation.%20The%20scene%20shows%20a%20modern%20office%20environment%20with%20natural%20lighting%20and%20professional%20attire.%20High-quality%20professional%20photography%20with%20soft%20focus%20background&width=400&height=300&seq=share1&orientation=landscape"
                            alt="Share Instantly" class="w-full h-48 object-cover object-top">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="affiliate" class="py-16 bg-gradient-to-br from-emerald-50 to-green-50">
        <div class="container mx-auto px-6">
            <div class="text-center mb-12">
                <div
                    class="inline-flex items-center px-6 py-3 bg-emerald-100 border border-emerald-200 rounded-full text-emerald-800 mb-6">
                    <i class="ri-global-line mr-2 text-lg"></i>
                    <span class="font-semibold">Available in Sri Lanka 🇱🇰 & Cambodia 🇰🇭</span>
                </div>
                <h2 class="text-3xl lg:text-4xl font-bold text-secondary mb-4">Earn with Our Affiliate Program</h2>
                <p class="text-lg text-gray-600 max-w-2xl mx-auto leading-relaxed">Share ebizcard and earn money for every
                    successful referral. Turn your connections into income.</p>
            </div>
            <div class="bg-white rounded-3xl p-8 shadow-xl border border-gray-100 max-w-5xl mx-auto">
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 items-center mb-8">
                    <div class="text-center">
                        <div
                            class="w-16 h-16 bg-gradient-to-br from-emerald-500 to-green-600 rounded-2xl flex items-center justify-center mx-auto mb-4">
                            <i class="ri-share-line text-white ri-2x"></i>
                        </div>
                        <h3 class="text-xl font-bold text-secondary mb-3">Share Your Link</h3>
                        <p class="text-gray-600">Get your unique referral link and share it with your network.</p>
                    </div>
                    <div class="text-center">
                        <div
                            class="w-16 h-16 bg-gradient-to-br from-primary to-blue-600 rounded-2xl flex items-center justify-center mx-auto mb-4">
                            <i class="ri-user-add-line text-white ri-2x"></i>
                        </div>
                        <h3 class="text-xl font-bold text-secondary mb-3">People Join</h3>
                        <p class="text-gray-600">When someone signs up for Professional plan using your link, you earn
                            commission.</p>
                    </div>
                    <div class="text-center">
                        <div
                            class="w-16 h-16 bg-gradient-to-br from-yellow-500 to-orange-500 rounded-2xl flex items-center justify-center mx-auto mb-4">
                            <i class="ri-money-dollar-circle-line text-white ri-2x"></i>
                        </div>
                        <h3 class="text-xl font-bold text-secondary mb-3">Earn & Withdraw</h3>
                        <p class="text-gray-600">Request payout when you reach minimum withdrawal amount.</p>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                    <div
                        class="text-center p-6 bg-gradient-to-br from-blue-50 to-indigo-50 rounded-2xl border border-blue-100">
                        <div class="text-sm font-semibold text-blue-600 mb-2">🇰🇭 Cambodia</div>
                        <div class="text-3xl font-bold text-primary mb-1">$0.5</div>
                        <div class="text-sm text-gray-600 mb-3">Per Referral</div>
                        <div class="text-lg font-semibold text-blue-700">$5 Min. Withdrawal</div>
                    </div>
                    <div
                        class="text-center p-6 bg-gradient-to-br from-emerald-50 to-green-50 rounded-2xl border border-emerald-100">
                        <div class="text-sm font-semibold text-emerald-600 mb-2">🇱🇰 Sri Lanka</div>
                        <div class="text-3xl font-bold text-emerald-600 mb-1">LKR 150</div>
                        <div class="text-sm text-gray-600 mb-3">Per Referral</div>
                        <div class="text-lg font-semibold text-emerald-700">LKR 1500 Min. Withdrawal</div>
                    </div>
                </div>
                <div class="bg-gray-50 rounded-2xl p-6 mb-8">
                    <h4 class="text-lg font-bold text-secondary mb-4 text-center">How It Works:</h4>
                    <ul class="grid grid-cols-1 md:grid-cols-2 gap-3 text-gray-600">
                        <li class="flex items-start">
                            <i class="ri-check-line text-emerald-500 text-lg mr-2 mt-0.5"></i>
                            <span>Request withdrawal through affiliate dashboard</span>
                        </li>
                        <li class="flex items-start">
                            <i class="ri-check-line text-emerald-500 text-lg mr-2 mt-0.5"></i>
                            <span>Direct bank transfer within 3-5 business days</span>
                        </li>
                        <li class="flex items-start">
                            <i class="ri-check-line text-emerald-500 text-lg mr-2 mt-0.5"></i>
                            <span>Available for Sri Lankan 🇱🇰 bank accounts</span>
                        </li>
                        <li class="flex items-start">
                            <i class="ri-check-line text-emerald-500 text-lg mr-2 mt-0.5"></i>
                            <span>Available for Cambodian 🇰🇭 bank accounts</span>
                        </li>
                    </ul>
                </div>
                <div class="text-center">
                    <div class="flex flex-col sm:flex-row gap-4 justify-center">
                        <a href="#join-affiliate"
                            class="px-8 py-3 bg-gradient-to-r from-emerald-500 to-green-600 text-white rounded-2xl text-lg font-bold hover:shadow-xl hover:scale-105 transition-all duration-300 whitespace-nowrap !rounded-button">
                            <i class="ri-user-add-line mr-2"></i>
                            Join Affiliate Program
                        </a>
                        <a href="#affiliate-terms"
                            class="px-8 py-3 border-2 border-emerald-500 text-emerald-600 rounded-2xl text-lg font-bold hover:bg-emerald-50 transition-all duration-300 whitespace-nowrap !rounded-button">
                            <i class="ri-file-text-line mr-2"></i>
                            Terms & Conditions
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- start pricing section -->
    <section id="pricing" class="py-20 bg-gradient-to-b from-[#F8FBFF] to-white">
        <div class="container mx-auto px-4">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold text-secondary mb-4">Simple, Transparent Pricing</h2>
                <p class="text-lg text-gray-600 max-w-2xl mx-auto"> {{ __("auth.choose_a_plan_that's_right_for_you") }}</p>
                <div class="flex items-center justify-center mt-8 gap-3">
                    <span
                        class="text-primary font-bold cursor-pointer select-none transition-all duration-300 hover:scale-110"
                        id="usdLabel">USD</span>
                    <label class="relative inline-flex items-center cursor-pointer">
                        <input type="checkbox" id="currencyToggle" class="sr-only peer">
                        <div
                            class="w-14 h-7 bg-gray-300 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-6 after:w-6 after:transition-all peer-checked:bg-primary">
                        </div>
                    </label>
                    <span
                        class="text-gray-700 font-medium cursor-pointer select-none transition-all duration-300 hover:scale-110"
                        id="lkrLabel">LKR</span>
                </div>
                <p class="text-sm text-gray-500 mt-2">Toggle to filter plans by currency</p>
            </div>
            <?php $planCount = count($plans); ?>
            @if($planCount == 4)
            <div class="flex flex-col md:flex-row justify-center items-center gap-8 max-w-4xl mx-auto">
            @else
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-5xl mx-auto">
            @endif
                <!-- Free Plan -->
                <?php $j = 0; ?>
                @foreach ($plans as $plan)
                    <?php
                    if ($j == 0) {
                        $ulhtml = '<ul class="space-y-3 mb-8">
                                            <li class="flex items-start">
                                                <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                                                    <i class="ri-check-line"></i>
                                                </span>
                                                <span class="text-gray-600">1 Digital Business Card</span>
                                            </li>
                                            <li class="flex items-start">
                                                <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                                                    <i class="ri-check-line"></i>
                                                </span>
                                                <span class="text-gray-600">Basic Templates</span>
                                            </li>
                                            <li class="flex items-start">
                                                <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                                                    <i class="ri-check-line"></i>
                                                </span>
                                                <span class="text-gray-600">QR Code Sharing</span>
                                            </li>
                                            <li class="flex items-start">
                                                <span class="w-5 h-5 flex items-center justify-center text-gray-400 mr-2 mt-0.5">
                                                    <i class="ri-close-line"></i>
                                                </span>
                                                <span class="text-gray-400">No NFC Card</span>
                                            </li>
                                            <li class="flex items-start">
                                                <span class="w-5 h-5 flex items-center justify-center text-gray-400 mr-2 mt-0.5">
                                                    <i class="ri-close-line"></i>
                                                </span>
                                                <span class="text-gray-400">No Analytics</span>
                                            </li>
                                        </ul>';
                    } elseif ($j == 1) {
                        $ulhtml = '<ul class="space-y-3 mb-8">
                    <li class="flex items-start">
                    <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                    <i class="ri-check-line"></i>
                    </span>
                    <span class="text-gray-600">Unlimited Digital Cards</span>
                    </li>
                    <li class="flex items-start">
                    <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                    <i class="ri-check-line"></i>
                    </span>
                    <span class="text-gray-600">All Premium Templates</span>
                    </li>
                    <li class="flex items-start">
                    <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                    <i class="ri-check-line"></i>
                    </span>
                    <span class="text-gray-600">QR Code Sharing</span>
                    </li>
                    <li class="flex items-start">
                    <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                    <i class="ri-check-line"></i>
                    </span>
                    <span class="text-gray-600">Advanced Analytics</span>
                    </li>
                    <li class="flex items-start">
                    <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                    <i class="ri-check-line"></i>
                    </span>
                    <span class="text-gray-600">Physical NFC Card</span>
                    </li>
                    </ul>';
                    } elseif ($j == 2) {
                        $ulhtml = '<ul class="space-y-3 mb-8">
                    <li class="flex items-start">
                    <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                    <i class="ri-check-line"></i>
                    </span>
                    <span class="text-gray-600">Unlimited Digital Cards</span>
                    </li>
                    <li class="flex items-start">
                    <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                    <i class="ri-check-line"></i>
                    </span>
                    <span class="text-gray-600">All Premium Templates</span>
                    </li>
                    <li class="flex items-start">
                    <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                    <i class="ri-check-line"></i>
                    </span>
                    <span class="text-gray-600">QR Code Sharing</span>
                    </li>
                    <li class="flex items-start">
                    <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                    <i class="ri-check-line"></i>
                    </span>
                    <span class="text-gray-600">Advanced Analytics</span>
                    </li>
                    <li class="flex items-start">
                    <span class="w-5 h-5 flex items-center justify-center text-gray-400 mr-2 mt-0.5">
                    <i class="ri-close-line"></i>
                    </span>
                    <span class="text-gray-400">No Physical NFC Card</span>
                    </li>
                    </ul>';
                    }
                    ?>
                    <div class="bg-white rounded-lg shadow-sm hover:shadow-lg transition-all duration-300 border border-gray-200 plan-card {{ $planCount == 4 ? 'w-full md:w-80 flex-shrink-0' : '' }}"
                        data-currency="{{ $plan->currency->currency_code ?? 'USD' }}">
                        @if ($plan->name == 'Digital + NFC Card')
                            <div
                                class="bg-white rounded-lg shadow-md hover:shadow-lg transition-all duration-300 border-2 border-primary relative transform scale-105">
                                <div
                                    class="absolute top-0 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-primary text-white px-4 py-1 rounded-full text-sm font-medium select-none">
                                    Most Popular
                                </div>
                        @endif
                        @if ($plan->name == 'Digital and NFC Card')
                            <div
                                class="bg-white rounded-lg shadow-md hover:shadow-lg transition-all duration-300 border-2 border-primary relative transform scale-105">
                                <div
                                    class="absolute top-0 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-primary text-white px-4 py-1 rounded-full text-sm font-medium select-none">
                                    Most Popular
                                </div>
                        @endif
                        <div class="p-8">
                            <h3 class="text-xl font-semibold text-secondary mb-2">{!! $plan->name !!}</h3>
                            <div class="flex items-end mb-6">
                                <span class="text-4xl font-bold text-secondary">
                                    <span class="currency-icon">{{ $plan->currency->currency_icon }}</span>
                                    <span class="price-amount">{{ number_format($plan->price, 2) }}</span>
                                </span>
                                @if ($plan->frequency == 1)
                                    <span class="text-gray-500 ml-1">/ {{ __('messages.plan.monthly') }}</span>
                                @elseif($plan->frequency == 2)
                                    <span class="text-gray-500 ml-1">/ {{ __('messages.plan.yearly') }}</span>
                                @endif

                            </div>


                            {!! $ulhtml !!}

                            @if (getLoggedInUserRoleId() != getSuperAdminRoleId())
                                @if (getLogInUser() && getLoggedInUserRoleId() != getSuperAdminRoleId())
                                    <div class="mx-auto">

                                        @if (
                                            !empty(getCurrentSubscription()) &&
                                                $plan->id == getCurrentSubscription()->plan_id &&
                                                !getCurrentSubscription()->isExpired())
                                            @if ($plan->price != 0)
                                                <button type="button"
                                                    class="btn btn-success rounded-pill mx-auto d-block cursor-remove-plan pricing-plan-button-active"
                                                    data-id="{{ $plan->id }}" data-turbo="false">
                                                    {{ __('messages.subscription.currently_active') }}</button>
                                            @else
                                                <button type="button"
                                                    class="text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100"
                                                    data-turbo="false">
                                                    {{ __('messages.subscription.renew_free_plan') }}
                                                </button>
                                            @endif
                                        @else
                                            @if (
                                                !empty(getCurrentSubscription()) &&
                                                    !getCurrentSubscription()->isExpired() &&
                                                    ($plan->price == 0 || $plan->price != 0))
                                                @if ($plan->hasZeroPlan->count() == 0)
                                                    <a href="{{ $plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)' }}"
                                                        class="w-full px-6 py-3 border border-primary text-primary rounded-button text-center block hover:bg-primary hover:text-white transition-colors whitespace-nowrap !rounded-button"
                                                        {{ $plan->price == 0 ? 'freePayment' : '' }}"
                                                        data-id="{{ $plan->id }}"
                                                        data-plan-price="{{ $plan->price }}" data-turbo="false">
                                                        {{ __('messages.subscription.switch_plan') }}</a>
                                                @else
                                                    <button type="button"
                                                        class="text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100"
                                                        data-turbo="false">
                                                        {{ __('messages.subscription.renew_free_plan') }}
                                                    </button>
                                                @endif
                                            @else
                                                @if ($plan->hasZeroPlan->count() == 0)
                                                    <a href="{{ $plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)' }}"
                                                        class="w-full px-6 py-3 border border-primary text-primary rounded-button text-center block hover:bg-primary hover:text-white transition-colors whitespace-nowrap !rounded-button{{ $plan->price == 0 ? 'freePayment' : '' }}"
                                                        data-id="{{ $plan->id }}"
                                                        data-plan-price="{{ $plan->price }}" data-turbo="false">
                                                        {{ __('messages.subscription.choose_plan') }}</a>
                                                @else
                                                    <button type="button"
                                                        class="text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100"
                                                        data-turbo="false">
                                                        {{ __('messages.subscription.renew_free_plan') }}
                                                    </button>
                                                @endif
                                            @endif
                                        @endif
                                    </div>
                                @else
                                    <div class="mx-auto">
                                        @if ($plan->hasZeroPlan->count() == 0)
                                            <a href="{{ $plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)' }}"
                                                class="w-full px-6 py-3 border border-primary text-primary rounded-button text-center block hover:bg-primary hover:text-white transition-colors whitespace-nowrap !rounded-button{{ $plan->price == 0 ? 'freePayment' : '' }}"
                                                data-id="{{ $plan->id }}" data-plan-price="{{ $plan->price }}"
                                                data-turbo="false">
                                                {{ __('messages.subscription.choose_plan') }}</a>
                                        @else
                                            <!--  <button type="button"
                                class="text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100"
                                data-turbo="false">
                                {{ __('messages.subscription.renew_free_plan') }}
                            </button> -->
                                            <a href="{{ $plan->price == 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)' }}"
                                                class="w-full px-6 py-3 border border-primary text-primary rounded-button text-center block hover:bg-primary hover:text-white transition-colors whitespace-nowrap !rounded-button{{ $plan->price == 0 ? 'freePayment' : '' }}"
                                                data-id="{{ $plan->id }}" data-plan-price="{{ $plan->price }}"
                                                data-turbo="false">
                                                {{ __('messages.subscription.choose_plan') }}</a>
                                        @endif
                                    </div>
                                @endif
                            @endif
                            <!--  <a href="#get-started" class="w-full px-6 py-3 border border-primary text-primary rounded-button text-center block hover:bg-primary hover:text-white transition-colors whitespace-nowrap !rounded-button">Start Free</a> -->
                        </div>
                    </div>
                    @if ($plan->name == 'Digital + NFC Card')
            </div> {{-- Close the border-2 highlight wrapper --}}
            @endif
            @if ($plan->name == 'Digital and NFC Card')
        </div> {{-- Close the border-2 highlight wrapper --}}
        @endif
        <?php $j++; ?>
        @endforeach
        <!-- Digital + NFC Plan -->
        @if($planCount == 4)
        </div>
        @else
        </div>
        @endif
        </div>
    </section>


    <!-- Enterprise Solutions Section -->
    {{-- <section id="enterprise" class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-secondary mb-4">Enterprise Solutions</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">Powerful tools for managing your organization's digital business cards at scale.</p>
        </div>
        <div class="flex flex-col md:flex-row items-center gap-12">
            <div class="w-full md:w-1/2">
                <div class="space-y-8">
                    <!-- Bulk User Management -->
                    <div class="flex items-start">
                        <div class="w-14 h-14 bg-primary/10 rounded-full flex items-center justify-center mr-6 shrink-0">
                            <i class="ri-team-line text-primary ri-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-secondary mb-2">Bulk User Management</h3>
                            <p class="text-gray-600">Easily create and manage digital business cards for your entire team. Import user data in bulk and set up cards instantly.</p>
                        </div>
                    </div>
                    <!-- HR Dashboard -->
                    <div class="flex items-start">
                        <div class="w-14 h-14 bg-primary/10 rounded-full flex items-center justify-center mr-6 shrink-0">
                            <i class="ri-dashboard-3-line text-primary ri-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-secondary mb-2">HR Dashboard</h3>
                            <p class="text-gray-600">Centralized control panel for managing employee digital identities. Track usage, monitor engagement, and manage permissions.</p>
                        </div>
                    </div>
                    <!-- Quota Control -->
                    <div class="flex items-start">
                        <div class="w-14 h-14 bg-primary/10 rounded-full flex items-center justify-center mr-6 shrink-0">
                            <i class="ri-settings-3-line text-primary ri-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-secondary mb-2">Quota Control</h3>
                            <p class="text-gray-600">Set and manage usage limits across departments and teams. Allocate resources efficiently and maintain control over enterprise usage.</p>
                        </div>
                    </div>
                    <!-- Team-wide Branding -->
                    <div class="flex items-start">
                        <div class="w-14 h-14 bg-primary/10 rounded-full flex items-center justify-center mr-6 shrink-0">
                            <i class="ri-paint-brush-line text-primary ri-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-secondary mb-2">Team-wide Branding</h3>
                            <p class="text-gray-600">Maintain consistent brand identity across all employee cards. Apply company-wide templates and enforce brand guidelines effortlessly.</p>
                        </div>
                    </div>
                    <div class="mt-12">
                        <a href="javascript:void(0)" onclick="openContactModal()"
                           class="px-8 py-4 bg-white border-2 border-primary text-primary rounded-button text-lg font-medium hover:bg-primary hover:text-white transition-colors inline-flex items-center whitespace-nowrap !rounded-button">
                            <i class="ri-customer-service-2-line mr-2"></i>
                            Contact Sales
                        </a>
                    </div>
                </div>
            </div>
            <div class="w-full md:w-1/2">
                <img src="https://readdy.ai/api/search-image?query=A%20modern%20enterprise%20dashboard%20interface%20showing%20business%20card%20management%20system%20with%20analytics%20graphs%2C%20user%20management%20panel%2C%20and%20branding%20controls.%20The%20interface%20is%20clean%20and%20professional%20with%20a%20light%20color%20scheme.%20The%20scene%20shows%20multiple%20cards%20being%20managed%20simultaneously%20with%20team%20collaboration%20features%20visible.%20High%20quality%203D%20rendering%20with%20attention%20to%20detail%20and%20modern%20UI%2FUX%20design%20principles&width=600&height=600&seq=enterprise1&orientation=squarish" alt="Enterprise Dashboard" class="w-full h-auto rounded-lg shadow-lg">
            </div>
        </div>
    </div>
</section> --}}
    <!-- Testimonials Section -->
    @if (!$testimonials->isEmpty())
        <section id="enterprise" class="py-20 bg-white">
            <div class="container mx-auto px-4">
                <div class="py-12">
                    <p class="text-center text-2xl font-medium text-black mb-8">Trusted by teams at</p>
                    <div class="flex flex-wrap justify-center items-center gap-8 md:gap-16">
                        @foreach ($testimonials as $testimonial)
                            <div
                                class="w-32 h-12 flex items-center justify-center grayscale opacity-70 hover:grayscale-0 hover:opacity-100 transition-all">
                                <img src="{{ $testimonial->testimonial_url }}" alt="Overleap logo" class="h-8">
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>
        </section>
    @endif
    <!-- end pricing section -->


    <!-- CTA Section -->
    <section class="py-20 bg-primary text-white">
        <div class="container mx-auto px-4 text-center">
            <h2 class="text-3xl md:text-4xl font-bold mb-6">Ready to Upgrade Your Networking?</h2>
            <p class="text-lg text-white/80 max-w-2xl mx-auto mb-10">Join thousands of professionals who are making
                meaningful connections with ebizcard.</p>
            @if (empty(getLogInUser()))
                <a href="{{ config('app.url') }}/admin/choose-payment-type/1" onclick="pauseAndRedirect(event)"
                    class="px-8 py-4 bg-white text-primary rounded-button text-lg font-medium hover:bg-gray-100 transition-colors inline-block whitespace-nowrap !rounded-button">
                    Get Started Free
                </a>
                <p class="mt-6 text-white/70">
                    No credit card required. 30-day free trial.
                </p>
            @endif
        </div>
    </section>
    <!-- end contact section -->

    <!-- Contact Sales Modal -->
    <div id="contactSalesModal" class="fixed inset-0 bg-black bg-opacity-60 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-xl p-8 w-full max-w-md relative shadow-lg">
            <!-- Close Button -->
            <button onclick="closeContactModal()"
                class="absolute top-3 right-3 text-black text-2xl font-bold">&times;</button>

            <h3 class="text-2xl font-semibold text-secondary mb-6 text-center">Contact Sales</h3>

            <div class="space-y-6 text-gray-700 text-base">
                <!-- Cambodia Contact -->
                <div>
                    <span class="font-medium block mb-1">Cambodia:</span>
                    <div class="flex items-center justify-between">
                        <span>+855 96 443 6883</span>
                        <div class="flex gap-3 text-xl">
                            <a href="https://t.me/+855964436883" target="_blank" title="Telegram"
                                class="text-primary hover:text-secondary">
                                <i class="ri-telegram-line"></i>
                            </a>
                            <a href="https://wa.me/855964436883" target="_blank" title="WhatsApp"
                                class="text-green-600 hover:text-green-800">
                                <i class="ri-whatsapp-line"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Sri Lanka Contact -->
                <div>
                    <span class="font-medium block mb-1">Sri Lanka:</span>
                    <div class="flex items-center justify-between">
                        <span>+94 777 567 776</span>
                        <div class="flex gap-3 text-xl">
                            <a href="https://t.me/+94777567776" target="_blank" title="Telegram"
                                class="text-primary hover:text-secondary">
                                <i class="ri-telegram-line"></i>
                            </a>
                            <a href="https://wa.me/94777567776" target="_blank" title="WhatsApp"
                                class="text-green-600 hover:text-green-800">
                                <i class="ri-whatsapp-line"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Email Contact -->
                <div>
                    <span class="font-medium block mb-1">Email:</span>
                    <a href="mailto:corporate@ebizcard.me" class="text-primary hover:underline">
                        corporate@ebizcard.me
                    </a>
                </div>
            </div>
        </div>
    </div>
    <!-- Get Started Contact Modal -->
    <div id="getStartedContactModal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-50" style="display: none;">
        <div class="bg-white rounded-lg shadow-xl max-w-2xl w-full mx-4 max-h-[90vh] overflow-y-auto">
            <div class="sticky top-0 bg-white border-b border-gray-200 px-6 py-4 flex justify-between items-center">
                <h3 class="text-xl font-semibold text-gray-800">{{ __('Get Started - Contact Us') }}</h3>
                <button type="button" id="closeContactModal" class="text-gray-400 hover:text-gray-600 text-2xl font-bold leading-none">
                    &times;
                </button>
            </div>
            <form id="getStartedContactForm" method="POST" action="{{ route('get-started-contact') }}" class="p-6">
                @csrf
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="first_name" class="block text-sm font-medium text-gray-700 mb-2">
                            {{ __('messages.form.first_name') }} <span class="text-red-500">*</span>
                        </label>
                        <input type="text" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent" id="first_name" name="first_name" required>
                        <div class="text-red-500 text-sm mt-1 hidden" id="first_name_error"></div>
                    </div>
                    <div>
                        <label for="last_name" class="block text-sm font-medium text-gray-700 mb-2">
                            {{ __('messages.form.last_name') }} <span class="text-red-500">*</span>
                        </label>
                        <input type="text" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent" id="last_name" name="last_name" required>
                        <div class="text-red-500 text-sm mt-1 hidden" id="last_name_error"></div>
                    </div>
                </div>
                <div class="mb-4">
                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                        {{ __('messages.user.email') }} <span class="text-red-500">*</span>
                    </label>
                    <input type="email" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent" id="email" name="email" required>
                    <div class="text-red-500 text-sm mt-1 hidden" id="email_error"></div>
                </div>
                <div class="mb-4">
                    <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">
                        {{ __('messages.user.contact_no') }} <span class="text-red-500">*</span>
                    </label>
                    <input type="tel" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent" id="phone" name="phone" required>
                    <div class="text-red-500 text-sm mt-1 hidden" id="phone_error"></div>
                </div>
                <div class="mb-4">
                    <label for="message" class="block text-sm font-medium text-gray-700 mb-2">
                        {{ __('messages.mail.messages') }} <span class="text-red-500">*</span>
                    </label>
                    <textarea class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent" id="message" name="message" rows="4" required></textarea>
                    <div class="text-red-500 text-sm mt-1 hidden" id="message_error"></div>
                </div>
                <div id="contactFormMessage" class="mb-4 hidden"></div>
                <div class="flex justify-end gap-3 pt-4 border-t border-gray-200">
                    <button type="button" id="closeContactModalBtn" class="px-6 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                        {{ __('messages.common.close') }}
                    </button>
                    <button type="submit" class="px-6 py-2 bg-primary text-white rounded-lg hover:bg-primary/90 transition-colors flex items-center gap-2" id="submitContactBtn">
                        <svg class="animate-spin h-4 w-4 hidden" id="submitSpinner" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        {{ __('messages.common.submit') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection
<script>
    function openContactModal() {
        // Only open when called by a user event
        if (typeof event === 'undefined' || !event.isTrusted) return;

        document.getElementById('contactSalesModal').classList.remove('hidden');
    }

    function closeContactModal() {
        document.getElementById('contactSalesModal').classList.add('hidden');
    }

    function pauseAndRedirect(event) {

        const video = document.getElementById('videoElement');
        const modal = document.getElementById('videoModal');

        if (video && !video.paused) {
            video.pause();
            video.currentTime = 0;
        }

        if (modal) {
            modal.classList.add('hidden');
        }

        // Now redirect after small delay to ensure pause applies
        setTimeout(() => {
            window.location.href = event.currentTarget.href;
        }, 0); // 0ms delay is usually enough
    }

    function openModal() {
        const modal = document.getElementById('videoModal');
        const video = document.getElementById('videoElement');

        modal.classList.remove('hidden');

        if (video) {
            video.currentTime = 0;
            video.play().catch(err => {
                console.warn("Autoplay blocked:", err);
            });
        }
    }

    function closeModal() {
        const modal = document.getElementById('videoModal');
        const video = document.getElementById('videoElement');
        video.pause();
        video.currentTime = 0;
        modal.classList.add('hidden');
    }

    function handleOutsideClick(event) {
        const modalContent = document.getElementById('videoModalContent');
        if (!modalContent.contains(event.target)) {
            closeModal();
        }
    }
    // Currency Filter Functionality
    document.addEventListener('DOMContentLoaded', function() {
        const currencyToggle = document.getElementById('currencyToggle');
        const usdLabel = document.getElementById('usdLabel');
        const lkrLabel = document.getElementById('lkrLabel');
        const planCards = document.querySelectorAll('.plan-card');

        // Default currency is USD
        let currentCurrency = 'USD';

        // Update label styles
        function updateLabelStyles() {
            if (currentCurrency === 'USD') {
                usdLabel.classList.add('text-primary', 'font-bold');
                usdLabel.classList.remove('text-gray-700');
                lkrLabel.classList.add('text-gray-700');
                lkrLabel.classList.remove('text-primary', 'font-bold');
            } else {
                lkrLabel.classList.add('text-primary', 'font-bold');
                lkrLabel.classList.remove('text-gray-700');
                usdLabel.classList.add('text-gray-700');
                usdLabel.classList.remove('text-primary', 'font-bold');
            }
        }

        // Filter plans by currency
        function filterPlansByCurrency() {
            let visibleCount = 0;

            planCards.forEach((card) => {
                const cardCurrency = card.getAttribute('data-currency');

                if (cardCurrency === currentCurrency) {
                    // Show card with fade-in animation
                    card.style.opacity = '0';
                    card.style.transform = 'scale(0.95)';
                    card.style.display = 'block';

                    setTimeout(() => {
                        card.style.opacity = '1';
                        card.style.transform = 'scale(1)';
                    }, 50);

                    visibleCount++;
                } else {
                    // Hide card with fade-out animation
                    card.style.opacity = '0';
                    card.style.transform = 'scale(0.95)';

                    setTimeout(() => {
                        card.style.display = 'none';
                    }, 300);
                }
            });

            // Show message if no plans found
            const pricingGrid = document.querySelector('.grid.grid-cols-1.md\\:grid-cols-3');
            let noPlansMessage = document.getElementById('no-plans-message');

            if (visibleCount === 0) {
                if (!noPlansMessage) {
                    noPlansMessage = document.createElement('div');
                    noPlansMessage.id = 'no-plans-message';
                    noPlansMessage.className = 'col-span-3 text-center py-10';
                    noPlansMessage.innerHTML = '<p class="text-xl text-gray-600">No plans available in ' +
                        currentCurrency + ' currency.</p>';
                    pricingGrid.appendChild(noPlansMessage);
                }
            } else {
                if (noPlansMessage) {
                    noPlansMessage.remove();
                }
            }
        }

        // Add CSS transition styles to plan cards
        planCards.forEach(card => {
            card.style.transition = 'opacity 0.3s ease, transform 0.3s ease';
        });

        // Initialize - show only USD plans by default
        filterPlansByCurrency();
        updateLabelStyles();

        // Toggle event listener
        currencyToggle.addEventListener('change', function() {
            currentCurrency = this.checked ? 'LKR' : 'USD';
            filterPlansByCurrency();
            updateLabelStyles();
        });

        // Label click handlers
        usdLabel.addEventListener('click', function() {
            currencyToggle.checked = false;
            currentCurrency = 'USD';
            filterPlansByCurrency();
            updateLabelStyles();
        });

        lkrLabel.addEventListener('click', function() {
            currencyToggle.checked = true;
            currentCurrency = 'LKR';
            filterPlansByCurrency();
            updateLabelStyles();
        });
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const modal = document.getElementById('getStartedContactModal');
        const openBtn = document.getElementById('openContactModalBtn');
        const openBtnMobile = document.getElementById('openContactModalBtnMobile');
        const closeBtn = document.getElementById('closeContactModal');
        const closeBtnFooter = document.getElementById('closeContactModalBtn');
        const form = document.getElementById('getStartedContactForm');
        const submitBtn = document.getElementById('submitContactBtn');
        const spinner = document.getElementById('submitSpinner');
        const messageDiv = document.getElementById('contactFormMessage');

        // Function to open modal
        function openModal() {
            modal.style.display = 'flex';
            document.body.style.overflow = 'hidden';
        }

        // Function to close modal
        function closeModal() {
            modal.style.display = 'none';
            document.body.style.overflow = '';
            form.reset();
            messageDiv.classList.add('hidden');
            messageDiv.classList.remove('bg-green-100', 'text-green-700', 'bg-red-100', 'text-red-700');
            // Clear all error messages
            document.querySelectorAll('[id$="_error"]').forEach(function(el) {
                el.classList.add('hidden');
                el.textContent = '';
            });
            // Remove border errors
            form.querySelectorAll('input, textarea').forEach(function(el) {
                el.classList.remove('border-red-500');
            });
        }

        // Event listeners for opening modal
        if (openBtn) {
            openBtn.addEventListener('click', openModal);
        }
        if (openBtnMobile) {
            openBtnMobile.addEventListener('click', openModal);
        }

        // Event listeners for closing modal
        if (closeBtn) {
            closeBtn.addEventListener('click', closeModal);
        }
        if (closeBtnFooter) {
            closeBtnFooter.addEventListener('click', closeModal);
        }

        // Close modal when clicking outside
        modal.addEventListener('click', function(e) {
            if (e.target === modal) {
                closeModal();
            }
        });

        // Close modal on ESC key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && modal.style.display === 'flex') {
                closeModal();
            }
        });

        // Form submission
        form.addEventListener('submit', function(e) {
            e.preventDefault();

            // Reset previous states
            messageDiv.classList.add('hidden');
            messageDiv.classList.remove('bg-green-100', 'text-green-700', 'bg-red-100', 'text-red-700');
            submitBtn.disabled = true;
            spinner.classList.remove('hidden');

            // Clear previous errors
            document.querySelectorAll('[id$="_error"]').forEach(function(el) {
                el.classList.add('hidden');
                el.textContent = '';
            });
            form.querySelectorAll('input, textarea').forEach(function(el) {
                el.classList.remove('border-red-500');
            });

            // Get form data
            const formData = new FormData(form);

            // Submit via AJAX
            fetch(form.action, {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                spinner.classList.add('hidden');
                submitBtn.disabled = false;

                if (data.success) {
                    messageDiv.classList.remove('hidden');
                    messageDiv.classList.add('bg-green-100', 'text-green-700', 'p-4', 'rounded-lg');
                    messageDiv.textContent = data.message || '{{ __("messages.placeholder.message_sent") }}';
                    form.reset();

                    // Close modal after 2 seconds
                    setTimeout(function() {
                        closeModal();
                    }, 2000);
                } else {
                    messageDiv.classList.remove('hidden');
                    messageDiv.classList.add('bg-red-100', 'text-red-700', 'p-4', 'rounded-lg');
                    messageDiv.textContent = data.message || '{{ __("messages.placeholder.something_went_wrong") }}';

                    // Display validation errors
                    if (data.errors) {
                        Object.keys(data.errors).forEach(function(key) {
                            const input = form.querySelector('[name="' + key + '"]');
                            const errorDiv = document.getElementById(key + '_error');
                            if (input) {
                                input.classList.add('border-red-500');
                            }
                            if (errorDiv) {
                                errorDiv.classList.remove('hidden');
                                errorDiv.textContent = data.errors[key][0];
                            }
                        });
                    }
                }
            })
            .catch(error => {
                spinner.classList.add('hidden');
                submitBtn.disabled = false;
                messageDiv.classList.remove('hidden');
                messageDiv.classList.add('bg-red-100', 'text-red-700', 'p-4', 'rounded-lg');
                messageDiv.textContent = '{{ __("messages.placeholder.something_went_wrong") }}';
                console.error('Error:', error);
            });
        });

        // Remove error styling on input
        form.querySelectorAll('input, textarea').forEach(function(input) {
            input.addEventListener('input', function() {
                this.classList.remove('border-red-500');
                const errorDiv = document.getElementById(this.name + '_error');
                if (errorDiv) {
                    errorDiv.classList.add('hidden');
                    errorDiv.textContent = '';
                }
            });
        });
    });
</script>
