<!-- start header section -->

<header class="fixed top-0 left-0 right-0 bg-white shadow-sm z-50">
    <div class="container mx-auto px-4 py-4 flex items-center justify-between">
        <div class="flex items-center">

            <img src="{{ getLogoUrl() }}" alt="ebizcard logo" class="h-8 mr-2">
        </div>
        <!-- Desktop Navigation -->
        <nav class="hidden md:flex items-center space-x-8">
            <a href="#features" class="text-gray-700 hover:text-primary transition-colors">Features</a>
            <a href="#pricing" class="text-gray-700 hover:text-primary transition-colors">Pricing</a>
            <a href="#enterprise" class="text-gray-700 hover:text-primary transition-colors">Templates</a>
            <a href="#enterprise" class="text-gray-700 hover:text-primary transition-colors">For Corporates</a>

            @if (empty(getLogInUser()))
                <a class="px-4 py-2 border border-primary rounded-button text-gray-700 hover:border-primary hover:text-primary transition-colors whitespace-nowrap" href="{{ route('login') }}"
                    data-turbo="false">
                    Login
                </a>

                <a href="{{ config('app.url') }}/admin/choose-payment-type/1"
                   class="px-4 py-2 bg-primary text-white rounded-button hover:bg-primary/90 transition-colors whitespace-nowrap !rounded-button">
                    Get Started
                </a>
            @else
                @if (getLogInUser()->hasrole('admin') || getLogInUser()->hasrole('user'))
                    <a class="px-4 py-2 border border-primary rounded-button text-gray-700 hover:border-primary hover:text-primary transition-colors whitespace-nowrap"
                       href="{{ route('admin.dashboard') }}" data-turbo="false">
                        {{ __('messages.dashboard') }}
                    </a>
                @endif

                @if (getLogInUser()->hasrole('super_admin'))
                    <a class="px-4 py-2 border border-primary rounded-button text-gray-700 hover:border-primary hover:text-primary transition-colors whitespace-nowrap"
                       href="{{ route('sadmin.dashboard') }}" data-turbo="false">
                        {{ __('messages.dashboard') }}
                    </a>
                @endif
            @endif
        </nav>
        <!-- Mobile Menu Button -->
        <button id="mobileMenuBtn" class="md:hidden w-10 h-10 flex items-center justify-center text-gray-700 relative z-[70]" type="button">
            <i class="ri-menu-line ri-2x" id="menuIcon"></i>
        </button>
    </div>
</header>
<!-- Mobile Navigation (Hidden by default) -->
<div id="mobileMenu" class="hidden fixed inset-0 bg-white z-[60] pt-20 px-4 overflow-y-auto">
    <nav class="flex flex-col space-y-6">
        <a href="#features" class="text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100">Features</a>
        <a href="#pricing" class="text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100">Pricing</a>
        <a href="#enterprise" class="text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100">Templates</a>
        <a href="corporate.html" class="text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100">For Corporates</a>
        @if (empty(getLogInUser()))

            <a class="w-full text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100 text-center  px-4 py-2 border border-primary rounded-button text-gray-700 whitespace-nowrap" href="{{ route('login') }}"
                data-turbo="false">
                Login
            </a>
            <a href="{{ config('app.url') }}/admin/choose-payment-type/1" class="px-4 py-3 bg-primary text-white rounded-button text-center text-xl !rounded-button">Get Started
            </a>
            @else
            @if (getLogInUser()->hasrole('admin') || getLogInUser()->hasrole('user'))
            <a class="w-full text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100 text-center  px-4 py-2 border border-primary rounded-button text-gray-700 whitespace-nowrap"
                href="{{ route('admin.dashboard') }}" data-turbo="false">
                {{ __('messages.dashboard') }}
            </a>
            @endif
            @if (getLogInUser()->hasrole('super_admin'))
            <a class="w-full text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100 text-center  px-4 py-2 border border-primary rounded-button text-gray-700 whitespace-nowrap"
                href="{{ route('sadmin.dashboard') }}" data-turbo="false">
                {{ __('messages.dashboard') }}
            </a>
            @endif
            @endif

    </nav>
</div>
<script>
(function() {
    let isInitialized = false;

    function initMobileMenu() {
        // Prevent multiple initializations
        if (isInitialized) {
            return;
        }

        const mobileMenuBtn = document.getElementById('mobileMenuBtn');
        const mobileMenu = document.getElementById('mobileMenu');
        const menuIcon = document.getElementById('menuIcon');

        if (!mobileMenuBtn || !mobileMenu || !menuIcon) {
            return;
        }

        isInitialized = true;

        mobileMenuBtn.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();

            // Toggle mobile menu visibility
            const isHidden = mobileMenu.classList.contains('hidden');

            if (isHidden) {
                // Show menu
                mobileMenu.classList.remove('hidden');
                mobileMenu.style.display = 'block';
                menuIcon.classList.remove('ri-menu-line');
                menuIcon.classList.add('ri-close-line');
                // Prevent body scroll when menu is open
                document.body.style.overflow = 'hidden';
            } else {
                // Hide menu
                mobileMenu.classList.add('hidden');
                mobileMenu.style.display = 'none';
                menuIcon.classList.remove('ri-close-line');
                menuIcon.classList.add('ri-menu-line');
                // Restore body scroll
                document.body.style.overflow = '';
            }
        });

        // Close menu when clicking on links
        const menuLinks = mobileMenu.querySelectorAll('a');
        menuLinks.forEach(link => {
            link.addEventListener('click', function() {
                mobileMenu.classList.add('hidden');
                mobileMenu.style.display = 'none';
                menuIcon.classList.remove('ri-close-line');
                menuIcon.classList.add('ri-menu-line');
                document.body.style.overflow = '';
            });
        });

        // Close menu when clicking outside (on the mobile menu overlay)
        mobileMenu.addEventListener('click', function(e) {
            // Only close if clicking on the overlay itself, not on links
            if (e.target === mobileMenu) {
                mobileMenu.classList.add('hidden');
                mobileMenu.style.display = 'none';
                menuIcon.classList.remove('ri-close-line');
                menuIcon.classList.add('ri-menu-line');
                document.body.style.overflow = '';
            }
        });
    }

    // Initialize on both DOMContentLoaded and turbo:load for Turbo compatibility
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            isInitialized = false;
            initMobileMenu();
        });
    } else {
        isInitialized = false;
        initMobileMenu();
    }

    document.addEventListener('turbo:load', function() {
        isInitialized = false;
        initMobileMenu();
    });
})();
</script>
<!-- end header section -->

<!-- end header section -->
