<span class="badge me-2">
    @php
        // Get currency from user's current active plan
        $currencyCode = 'USD';
        $user = $row->user ?? null;

        if ($user && $user->subscriptions) {
            // Get the active subscription from the loaded relationships
            $currentSubscription = $user->subscriptions
                ->where('status', \App\Models\Subscription::ACTIVE)
                ->sortByDesc('created_at')
                ->first();

            if ($currentSubscription && $currentSubscription->plan && $currentSubscription->plan->currency) {
                $currencyCode = $currentSubscription->plan->currency->currency_code;
            }
        }

        // If not found in loaded relationships, query directly
        if ($currencyCode === 'USD' && $user) {
            $currentSubscription = \App\Models\Subscription::where('tenant_id', $user->tenant_id)
                ->where('status', \App\Models\Subscription::ACTIVE)
                ->with('plan.currency')
                ->orderBy('created_at', 'desc')
                ->first();

            if ($currentSubscription && $currentSubscription->plan && $currentSubscription->plan->currency) {
                $currencyCode = $currentSubscription->plan->currency->currency_code;
            }
        }

        $currency = \App\Models\Currency::where('currency_code', $currencyCode)->first();

        // Use 'රු' for LKR, otherwise use currency icon from database
        if ($currencyCode === 'LKR') {
            $currencyIcon = 'LKR';
        } else {
            $currencyIcon = $currency ? $currency->currency_icon : '$';
        }

        $currencyPosition = getSuperAdminSettingValue('currency_after_amount');
    @endphp
    @if($currencyPosition)
        {{ number_format($row->amount, 2) }}{{ $currencyIcon }}
    @else
        {{ $currencyIcon }}{{ number_format($row->amount, 2) }}
    @endif
 </span>
