@php
    $allowedVcards = auth()->user()->subscription->no_of_vcards ?? 0;
    $activeCount = \App\Models\Vcard::where('tenant_id', getLogInTenantId())
                    ->where('status', 1)->count();
    $isBlocked = !$row->status && $activeCount >= $allowedVcards;
@endphp

<label class="form-check form-switch d-flex justify-content-center">
    <input name="is_active" 
           data-id="{{ $row->id }}" 
           class="form-check-input vcardStatus"
           type="checkbox" 
           value="1" 
           {{ $row->status == 1 ? 'checked' : '' }}
           data-blocked="{{ $isBlocked ? '1' : '0' }}">
</label>
@once
<script>
    // Toast listener (for other Livewire-triggered toasts)
    // window.addEventListener('show-toast', event => {
    //     toastr[event.detail.type](event.detail.message);
    // });

    // Livewire switch handler
    document.addEventListener('livewire:load', function () {

        document.body.addEventListener('click', function(e) {
            const checkbox = e.target.closest('.vcardStatus');
            if (!checkbox) return;

            const isBlocked = checkbox.dataset.blocked === '1';
            const vcardId = checkbox.dataset.id;

            if (isBlocked) {
                // Show toast immediately
                toastr.error('You reached your active vCard limit. Deactivate another to enable this.');
                
                // Optional: notify Livewire
                Livewire.emit('blockedVcardClicked', vcardId);

                e.preventDefault();
                return;
            }

            // Normal toggle
            Livewire.emit('updateStatus', vcardId);
        });

    });
</script>
@endonce
