<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="<?php echo e(getFaviconUrl()); ?>" type="image/png">
    <?php if(!empty($metas)): ?>
    <?php if($metas['meta_description']): ?>
    <meta name="description" content="<?php echo e($metas['meta_description']); ?>">
    <?php endif; ?>
    <?php if($metas['meta_keyword']): ?>
    <meta name="keywords" content="<?php echo e($metas['meta_keyword']); ?>">
    <?php endif; ?>
    <?php if($metas['home_title'] && $metas['site_title']): ?>
    <title><?php echo e($metas['home_title']); ?> | <?php echo e($metas['site_title']); ?></title>
    <?php else: ?>
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(getAppName()); ?></title>
    <?php endif; ?>
    <?php else: ?>
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(getAppName()); ?></title>
    <meta name="description" content="">
    <meta name="keywords" content="">
    <?php endif; ?>

    <?php if(!empty(getAppLogo())): ?>
    <meta property="og:image" content="<?php echo e(getAppLogo()); ?>" />
    <?php endif; ?>

    

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css"
        integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- <link href="<?php echo e(mix('assets/css/public.css')); ?>" rel="stylesheet" type="text/css"> -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/third-party.css')); ?>">
    
    <link href="<?php echo e(asset('assets/css/front/front-custom.css')); ?>" rel="stylesheet" type="text/css">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Pacifico&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/remixicon/4.6.0/remixicon.min.css">
    <script src="https://cdn.tailwindcss.com/3.4.16"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#0B84FF',
                        secondary: '#1A2B48'
                    },
                    borderRadius: {
                        'none': '0px',
                        'sm': '4px',
                        DEFAULT: '8px',
                        'md': '12px',
                        'lg': '16px',
                        'xl': '20px',
                        '2xl': '24px',
                        '3xl': '32px',
                        'full': '9999px',
                        'button': '8px'
                    }
                }
            }
        }
    </script>
    <script src="<?php echo e(mix('assets/js/front-third-party.js')); ?>"></script>
    <script src="<?php echo e(asset('messages.js')); ?>"></script>

    <?php $langSession = Session::get('languageName');
    $frontLanguage = !isset($langSession) ? getSuperAdminSettingValue('default_language') : $langSession;
    ?>
    <script>
        let frontLanguage = "<?php echo e($frontLanguage); ?>"
        Lang.setLocale(frontLanguage)
    </script>
    <script src="<?php echo e(mix('assets/js/front-pages.js')); ?>"></script>

    <?php echo getSuperAdminSettingValue('extra_js_front'); ?>

    <?php echo app('Tightenco\Ziggy\BladeRouteGenerator')->generate(); ?>

    <script>
        $(document).ready(function() {
            $('html, body').animate({
                scrollTop: $('html').offset().top,
            });
        });
    </script>
    <!--google analytics code-->
    <?php if(!empty($metas['google_analytics'])): ?>
    <?php echo $metas['google_analytics']; ?>

    <?php endif; ?>


    <style>
        :where([class^="ri-"])::before {
            content: "\f3c2";
        }

        body {
            font-family: 'Inter', sans-serif;
        }

        .bg-gradient-radial {
            background-image: radial-gradient(var(--tw-gradient-stops));
        }

        .hero-gradient {
            background: linear-gradient(90deg, rgba(255, 255, 255, 1) 0%, rgba(255, 255, 255, 0.9) 50%, rgba(255, 255, 255, 0) 100%);
        }

        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
        }

        .custom-checkbox {
            appearance: none;
            -webkit-appearance: none;
            width: 20px;
            height: 20px;
            border: 2px solid #e2e8f0;
            border-radius: 4px;
            outline: none;
            cursor: pointer;
            position: relative;
        }

        .custom-checkbox:checked {
            background-color: #2B8EFE;
            border-color: #2B8EFE;
        }

        .custom-checkbox:checked::after {
            content: "";
            position: absolute;
            top: 2px;
            left: 6px;
            width: 6px;
            height: 10px;
            border: solid white;
            border-width: 0 2px 2px 0;
            transform: rotate(45deg);
        }

        .custom-switch {
            position: relative;
            display: inline-block;
            width: 50px;
            height: 24px;
        }

        .custom-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .switch-slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #e2e8f0;
            transition: .4s;
            border-radius: 34px;
        }

        .switch-slider:before {
            position: absolute;
            content: "";
            height: 18px;
            width: 18px;
            left: 3px;
            bottom: 3px;
            background-color: white;
            transition: .4s;
            border-radius: 50%;
        }

        input:checked+.switch-slider {
            background-color: #2B8EFE;
        }

        input:checked+.switch-slider:before {
            transform: translateX(26px);
        }
    </style>
</head>

<body class="bg-white text-gray-800" data-bs-offset="71" data-turbo-suppress-warning>
    <!-- start header section -->
    <?php echo $__env->make('front.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('front.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\Ebizcard17-11-25\resources\views/front/layouts/app.blade.php ENDPATH**/ ?>