<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <?php if(checkFeature('seo')): ?>
        <?php if($vcard->meta_description): ?>
            <meta name="description" content="<?php echo e($vcard->meta_description); ?>">
        <?php endif; ?>
        <?php if($vcard->meta_keyword): ?>
            <meta name="keywords" content="<?php echo e($vcard->meta_keyword); ?>">
        <?php endif; ?>
    <?php else: ?>
        <meta name="description" content="<?php echo e($vcard->description); ?>">
        <meta name="keywords" content="">
    <?php endif; ?>
    <meta property="og:image" content="<?php echo e($vcard->cover_url); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php if(checkFeature('seo') && $vcard->site_title && $vcard->home_title): ?>
        <title><?php echo e($vcard->home_title); ?> | <?php echo e($vcard->site_title); ?></title>
    <?php else: ?>
        <title><?php echo e(getAppName()); ?></title>
    <?php endif; ?>


    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(getFaviconUrl()); ?>" type="image/png">

    <link href="<?php echo e(asset('front/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(mix('assets/css/vcard3.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/third-party.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/plugins.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom-vcard.css')); ?>">

    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500&display=swap" rel="stylesheet">
    <?php if(checkFeature('custom-fonts') && $vcard->font_family): ?>
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=<?php echo e($vcard->font_family); ?>">
    <?php endif; ?>
    <?php if($vcard->font_family || $vcard->font_size || $vcard->custom_css): ?>
        <style>
            <?php if(checkFeature('custom-fonts')): ?>
                <?php if($vcard->font_family): ?>
                    body {
                        font-family: <?php echo e($vcard->font_family); ?>;
                    }

                <?php endif; ?>
                <?php if($vcard->font_size): ?>
                    div>h4 {
                        font-size: <?php echo e($vcard->font_size); ?>px !important;
                    }
                <?php endif; ?>
            <?php endif; ?>

            <?php if(isset(checkFeature('advanced')->custom_css)): ?>
                <?php echo $vcard->custom_css; ?>

            <?php endif; ?>
        </style>
    <?php endif; ?>
</head>

<body>
    <div class="container p-0">

        <div class="vcard-three main-content  w-100 mx-auto content-blur allSection collapse show">

            <div class="vcard-three__product_details_page py-3 mb-10 mt-0">
                <div class="row justify-content-between">
                    <div class="col-4">
                        <h4 class="vcard-three-heading p-5"><?php echo e(__('messages.vcard.products')); ?></h4>
                    </div>
                    <div class="col-4 mt-6 text-center">
                        <a class="vcard-three-btn text-white text-decoration-none" href="<?php echo e(route('vcard.show', ['alias' => $vcard->url_alias])); ?>"
                            role="button"><?php echo e(__('messages.common.back')); ?></a>
                    </div>
                </div>
                <div class="container">
                    <div class="g-4 product-slider overflow-hidden">
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-2 d-flex justify-content-center">
                                <a <?php if($product->product_url): ?> href="<?php echo e($product->product_url); ?>" <?php endif; ?>
                                    target="_blank" class="text-decoration-none fs-6">
                                    <div class="card product-card p-2 border-0 w-75 h-100">
                                        <div class="product-profile d-flex justify-content-center">
                                            <img src="<?php echo e($product->product_icon); ?>" alt="profile" class="w-50"
                                                height="208px" />
                                        </div>
                                        <div class="product-details mt-3">
                                            <h4 class="text-white"><?php echo e($product->name); ?></h4>
                                            <p class="mb-2 text-white">
                                                <?php echo e($product->description); ?>

                                            </p>
                                            <?php if($product->currency_id && $product->price): ?>
                                                <span class="text-white product-price-<?php echo e($product->id); ?>"><?php echo e($product->currency->currency_icon); ?><?php echo e(number_format($product->price, 2)); ?></span>
                                            <?php elseif($product->price): ?>
                                                <span class="text-white product-price-<?php echo e($product->id); ?>"><?php echo e(getUserCurrencyIcon($vcard->user->id)); ?><?php echo e($product->price); ?></span>
                                            <?php endif; ?>
                                        </a>
                                            <?php if(!empty($product->price)): ?>
                                                <div class="my-5 text-center">
                                                    <button class="product-btn text-white rounded  buy-product" data-id="<?php echo e($product->id); ?>"><?php echo e(__('messages.subscription.buy_now')); ?></button>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('vcardTemplates.product-buy', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script src="https://js.stripe.com/v3/"></script>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/front-third-party.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('front/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/slider/js/slick.min.js')); ?>" type="text/javascript"></script>
    <script>
        <?php if(checkFeature('seo') && $vcard->google_analytics): ?>
            <?php echo $vcard->google_analytics; ?>

        <?php endif; ?>

        <?php if(isset(checkFeature('advanced')->custom_js) && $vcard->custom_js): ?>
            <?php echo $vcard->custom_js; ?>

        <?php endif; ?>
    </script>
    <?php
        $setting = \App\Models\UserSetting::where('user_id', $vcard->tenant->user->id)
            ->where('key', 'stripe_key')
            ->first();
    ?>

    <script>
         let stripe = '';
        <?php if(!empty($setting) && !empty($setting->value)): ?>
            stripe = Stripe('<?php echo e($setting->value); ?>');
        <?php endif; ?>
        let isEdit = false;
        let password = "<?php echo e(isset(checkFeature('advanced')->password) && !empty($vcard->password)); ?>";
        let passwordUrl = "<?php echo e(route('vcard.password', $vcard->id)); ?>";
        let enquiryUrl = "<?php echo e(route('enquiry.store', ['vcard' => $vcard->id, 'alias' => $vcard->url_alias])); ?>";
        let appointmentUrl = "<?php echo e(route('appointment.store', ['vcard' => $vcard->id, 'alias' => $vcard->url_alias])); ?>";
        let paypalUrl = "<?php echo e(route('paypal.init')); ?>";
        let slotUrl = "<?php echo e(route('appointment-session-time', $vcard->url_alias)); ?>";
        let appUrl = "<?php echo e(config('app.url')); ?>";
        let vcardId = <?php echo e($vcard->id); ?>;
        let vcardAlias = "<?php echo e($vcard->url_alias); ?>";
        let languageChange = "<?php echo e(url('language')); ?>";
        let lang = "<?php echo e(checkLanguageSession($vcard->url_alias)); ?>";
    </script>
    <?php echo app('Tightenco\Ziggy\BladeRouteGenerator')->generate(); ?>
    <script src="<?php echo e(asset('messages.js')); ?>"></script>
    <script src="<?php echo e(mix('assets/js/custom/helpers.js')); ?>"></script>
    <script src="<?php echo e(mix('assets/js/custom/custom.js')); ?>"></script>
    <script src="<?php echo e(mix('assets/js/vcards/vcard-view.js')); ?>"></script>
    <script src="<?php echo e(mix('assets/js/lightbox.js')); ?>"></script>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\Ebizcard17-11-25\resources\views/vcardTemplates/products/vcard3.blade.php ENDPATH**/ ?>